/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.blocks;

import com.google.common.collect.Lists;
import com.tiviacz.travelersbackpack.blockentity.TravelersBackpackBlockEntity;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModBlockEntityTypes;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import java.util.LinkedList;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class TravelersBackpackBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final double X = 0.7777777777777778;
    private static final double Y = 0.7692307692307693;
    private static final double Z = 0.7777777777777778;
    private static final double OX = 1.775;
    private static final double OY = 1.655;
    private static final double OZ = 1.778;
    private static final VoxelShape BACKPACK_SHAPE_NORTH = Stream.of(Block.m_49796_((double)4.108333333333333, (double)0.8857692307692308, (double)6.4446666666666665, (double)11.886111111111111, (double)10.116538461538461, (double)10.333555555555556), Block.m_49796_((double)4.108333333333333, (double)0.11653846153846148, (double)7.222444444444445, (double)11.886111111111111, (double)0.8857692307692308, (double)10.333555555555556), Block.m_49796_((double)4.886111111111111, (double)2.4857692307692307, (double)4.889111111111111, (double)11.108333333333334, (double)7.101153846153847, (double)6.4446666666666665), Block.m_49796_((double)4.886111111111111, (double)1.655, (double)10.333555555555556, (double)5.663888888888889, (double)7.808846153846154, (double)11.111333333333334), Block.m_49796_((double)10.330555555555556, (double)1.655, (double)10.333555555555556, (double)11.108333333333334, (double)7.808846153846154, (double)11.111333333333334), Block.m_49796_((double)0.9972222222222221, (double)0.11653846153846148, (double)6.833555555555556, (double)4.108333333333333, (double)7.808846153846154, (double)9.944666666666667), Block.m_49796_((double)11.886111111111111, (double)0.11653846153846148, (double)6.833555555555556, (double)14.997222222222224, (double)7.808846153846154, (double)9.944666666666667)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape BACKPACK_SHAPE_SOUTH = Stream.of(Block.m_49796_((double)4.108333333333333, (double)0.8857692307692308, (double)5.666888888888889, (double)11.886111111111111, (double)10.116538461538461, (double)9.555777777777777), Block.m_49796_((double)4.108333333333333, (double)0.11653846153846148, (double)5.666888888888889, (double)11.886111111111111, (double)0.8857692307692308, (double)8.778), Block.m_49796_((double)4.886111111111111, (double)2.4857692307692307, (double)9.555777777777777, (double)11.108333333333334, (double)7.101153846153847, (double)11.111333333333334), Block.m_49796_((double)4.886111111111111, (double)1.655, (double)4.889111111111111, (double)5.663888888888889, (double)7.808846153846154, (double)5.666888888888889), Block.m_49796_((double)10.330555555555556, (double)1.655, (double)4.889111111111111, (double)11.108333333333334, (double)7.808846153846154, (double)5.666888888888889), Block.m_49796_((double)0.9972222222222221, (double)0.11653846153846148, (double)6.055777777777777, (double)4.108333333333333, (double)7.808846153846154, (double)9.16688888888889), Block.m_49796_((double)11.886111111111111, (double)0.11653846153846148, (double)6.055777777777777, (double)14.997222222222224, (double)7.808846153846154, (double)9.16688888888889)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape BACKPACK_SHAPE_WEST = Stream.of(Block.m_49796_((double)6.441666666666666, (double)0.8857692307692308, (double)4.1113333333333335, (double)10.330555555555556, (double)10.116538461538461, (double)11.889111111111111), Block.m_49796_((double)7.219444444444445, (double)0.11653846153846148, (double)4.1113333333333335, (double)10.330555555555556, (double)0.8857692307692308, (double)11.889111111111111), Block.m_49796_((double)4.886111111111111, (double)2.4857692307692307, (double)4.889111111111111, (double)6.441666666666666, (double)7.101153846153847, (double)11.111333333333334), Block.m_49796_((double)10.330555555555556, (double)1.655, (double)4.889111111111111, (double)11.108333333333334, (double)7.808846153846154, (double)5.666888888888889), Block.m_49796_((double)10.330555555555556, (double)1.655, (double)10.333555555555556, (double)11.108333333333334, (double)7.808846153846154, (double)11.111333333333334), Block.m_49796_((double)6.830555555555556, (double)0.11653846153846148, (double)1.0002222222222223, (double)9.941666666666666, (double)7.808846153846154, (double)4.1113333333333335), Block.m_49796_((double)6.830555555555556, (double)0.11653846153846148, (double)11.889111111111111, (double)9.941666666666666, (double)7.808846153846154, (double)15.000222222222224)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape BACKPACK_SHAPE_EAST = Stream.of(Block.m_49796_((double)5.663888888888889, (double)0.8857692307692308, (double)4.1113333333333335, (double)9.552777777777777, (double)10.116538461538461, (double)11.889111111111111), Block.m_49796_((double)5.663888888888889, (double)0.11653846153846148, (double)4.1113333333333335, (double)8.775, (double)0.8857692307692308, (double)11.889111111111111), Block.m_49796_((double)9.552777777777777, (double)2.4857692307692307, (double)4.889111111111111, (double)11.108333333333334, (double)7.101153846153847, (double)11.111333333333334), Block.m_49796_((double)4.886111111111111, (double)1.655, (double)4.889111111111111, (double)5.663888888888889, (double)7.808846153846154, (double)5.666888888888889), Block.m_49796_((double)4.886111111111111, (double)1.655, (double)10.333555555555556, (double)5.663888888888889, (double)7.808846153846154, (double)11.111333333333334), Block.m_49796_((double)6.052777777777777, (double)0.11653846153846148, (double)1.0002222222222223, (double)9.16388888888889, (double)7.808846153846154, (double)4.1113333333333335), Block.m_49796_((double)6.052777777777777, (double)0.11653846153846148, (double)11.889111111111111, (double)9.16388888888889, (double)7.808846153846154, (double)15.000222222222224)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public TravelersBackpackBlock(BlockBehaviour.Properties builder) {
        super(builder.m_60913_(1.0f, Float.MAX_VALUE).m_280606_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> BACKPACK_SHAPE_SOUTH;
            case Direction.EAST -> BACKPACK_SHAPE_EAST;
            case Direction.WEST -> BACKPACK_SHAPE_WEST;
            default -> BACKPACK_SHAPE_NORTH;
        };
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TravelersBackpackBlockEntity) {
            TravelersBackpackBlockEntity blockEntity2 = (TravelersBackpackBlockEntity)blockEntity;
            blockEntity2.openGUI(player, blockEntity2, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return false;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TravelersBackpackBlockEntity) {
            TravelersBackpackBlockEntity blockEntity2 = (TravelersBackpackBlockEntity)blockEntity;
            if (!level.f_46443_) {
                if (player.m_7500_() && blockEntity2.hasData()) {
                    ItemStack stack = blockEntity2.transferToItemStack(this.m_5456_().m_7968_());
                    ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
                    itementity.m_32060_();
                    level.m_7967_((Entity)itementity);
                }
                if (state.m_60734_() == ModBlocks.MELON_TRAVELERS_BACKPACK.get()) {
                    BackpackAbilities.melonAbility(blockEntity2);
                }
                blockEntity2.removeSleepingBag(level, (Direction)state.m_61143_((Property)FACING));
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stack = new ItemStack((ItemLike)this.m_5456_(), 1);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TravelersBackpackBlockEntity) {
            TravelersBackpackBlockEntity blockEntity2 = (TravelersBackpackBlockEntity)blockEntity;
            blockEntity2.transferToItemStack(stack);
        }
        return stack;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TravelersBackpackBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ || !TravelersBackpackConfig.enableBackpackAbilities || !BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, state.m_60734_().m_5456_().m_7968_()) ? null : BackpackUtils.getTicker(blockEntityType, (BlockEntityType)ModBlockEntityTypes.TRAVELERS_BACKPACK.get(), TravelersBackpackBlockEntity::tick);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        super.m_214162_(state, level, pos, rand);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TravelersBackpackBlockEntity) {
            TravelersBackpackBlockEntity blockEntity2 = (TravelersBackpackBlockEntity)blockEntity;
            BackpackAbilities.ABILITIES.animateTick(blockEntity2, state, level, pos, rand);
        }
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader world, BlockPos pos) {
        TravelersBackpackBlockEntity blockEntity;
        BlockEntity blockEntity2 = world.m_7702_(pos);
        if (blockEntity2 instanceof TravelersBackpackBlockEntity && (blockEntity = (TravelersBackpackBlockEntity)blockEntity2).getAbilityValue() && state.m_60734_() == ModBlocks.BOOKSHELF_TRAVELERS_BACKPACK.get()) {
            return 5.0f;
        }
        return super.getEnchantPowerBonus(state, world, pos);
    }

    public int m_6378_(BlockState state, BlockGetter getter, BlockPos pos, Direction direction) {
        TravelersBackpackBlockEntity blockEntity;
        BlockEntity blockEntity2 = getter.m_7702_(pos);
        if (blockEntity2 instanceof TravelersBackpackBlockEntity && (blockEntity = (TravelersBackpackBlockEntity)blockEntity2).getAbilityValue() && state.m_60734_() == ModBlocks.REDSTONE_TRAVELERS_BACKPACK.get()) {
            return 15;
        }
        return super.m_6378_(state, getter, pos, direction);
    }

    public boolean m_7899_(BlockState state) {
        return state.m_60734_() == ModBlocks.REDSTONE_TRAVELERS_BACKPACK.get();
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pOldState.m_60713_(pState.m_60734_()) && pState.m_60734_() == ModBlocks.SPONGE_TRAVELERS_BACKPACK.get()) {
            this.tryAbsorbWater(pLevel, pPos);
        }
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
    }

    public void m_6861_(BlockState state, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        if (state.m_60734_() == ModBlocks.SPONGE_TRAVELERS_BACKPACK.get()) {
            this.tryAbsorbWater(pLevel, pPos);
        }
        super.m_6861_(state, pLevel, pPos, pBlock, pFromPos, pIsMoving);
    }

    public void tryAbsorbWater(Level level, BlockPos pos) {
        TravelersBackpackBlockEntity blockEntity;
        BlockEntity blockEntity2 = level.m_7702_(pos);
        if (blockEntity2 instanceof TravelersBackpackBlockEntity && (blockEntity = (TravelersBackpackBlockEntity)blockEntity2).getAbilityValue() && (blockEntity.getLeftTank().isEmpty() || blockEntity.getLeftTank().getFluid().getFluid().m_6212_((Fluid)Fluids.f_76193_) && blockEntity.getLeftTank().getFluidAmount() < blockEntity.getLeftTank().getCapacity() || blockEntity.getRightTank().isEmpty() || blockEntity.getRightTank().getFluid().getFluid().m_6212_((Fluid)Fluids.f_76193_) && blockEntity.getRightTank().getFluidAmount() < blockEntity.getRightTank().getCapacity()) && this.removeWaterBreadthFirstSearch(level, pos, blockEntity)) {
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)Blocks.f_49990_.m_49966_()));
        }
    }

    private boolean removeWaterBreadthFirstSearch(Level p_56808_, BlockPos p_56809_, TravelersBackpackBlockEntity blockEntity) {
        LinkedList queue = Lists.newLinkedList();
        queue.add(new Tuple((Object)p_56809_, (Object)0));
        int i = 0;
        while (!queue.isEmpty()) {
            Tuple tuple = (Tuple)queue.poll();
            BlockPos blockpos = (BlockPos)tuple.m_14418_();
            int j = (Integer)tuple.m_14419_();
            for (Direction direction : Direction.values()) {
                BlockPos blockpos1 = blockpos.m_121945_(direction);
                BlockState blockstate = p_56808_.m_8055_(blockpos1);
                FluidState fluidstate = p_56808_.m_6425_(blockpos1);
                if (!fluidstate.m_205070_(FluidTags.f_13131_)) continue;
                if (blockstate.m_60734_() instanceof BucketPickup && !((BucketPickup)blockstate.m_60734_()).m_142598_((LevelAccessor)p_56808_, blockpos1, blockstate).m_41619_()) {
                    ++i;
                    if (blockEntity.getLeftTank().isEmpty() || blockEntity.getLeftTank().getFluid().getFluid().m_6212_((Fluid)Fluids.f_76193_) && blockEntity.getLeftTank().getFluidAmount() < blockEntity.getLeftTank().getCapacity()) {
                        blockEntity.getLeftTank().fill(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE);
                    } else if (blockEntity.getRightTank().isEmpty() || blockEntity.getRightTank().getFluid().getFluid().m_6212_((Fluid)Fluids.f_76193_) && blockEntity.getRightTank().getFluidAmount() < blockEntity.getRightTank().getCapacity()) {
                        blockEntity.getRightTank().fill(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE);
                    }
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (blockstate.m_60734_() instanceof LiquidBlock) {
                    p_56808_.m_7731_(blockpos1, Blocks.f_50016_.m_49966_(), 3);
                    ++i;
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (!(blockstate.m_60713_(Blocks.f_50575_) || blockstate.m_60713_(Blocks.f_50576_) || blockstate.m_60713_(Blocks.f_50037_) || blockstate.m_60713_(Blocks.f_50038_))) {
                    return false;
                }
                BlockEntity blockentity = blockstate.m_155947_() ? p_56808_.m_7702_(blockpos1) : null;
                TravelersBackpackBlock.m_49892_((BlockState)blockstate, (LevelAccessor)p_56808_, (BlockPos)blockpos1, (BlockEntity)blockentity);
                p_56808_.m_7731_(blockpos1, Blocks.f_50016_.m_49966_(), 3);
                ++i;
                if (j >= 6) continue;
                queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
            }
            if (i <= 64) continue;
            break;
        }
        return i > 0;
    }
}

